# Install and load necessary packages
if (!require("survival")) install.packages("survival")
if (!require("readxl")) install.packages("readxl")
if (!require("rms")) install.packages("rms")  # If you need the rms package
if (!require("regplot")) install.packages("regplot")  # Install regplot package

library(survival)
library(readxl)
library(rms)
library(regplot)

# Load dataset
data <- read_excel("model 1.xlsx")

# Convert categorical variables
data$Group <- as.factor(data$Group)

# Create data distribution object
dd <- datadist(data)  # Create data distribution object
options(datadist = "dd")  # Set data distribution object as default

# 1-year survival Cox regression model
cox1 <- cph(Surv(Follow_up_time, AE) ~ Group + FEV1, 
            surv = TRUE, x = TRUE, y = TRUE, time.inc = 1 * 12, data = data)

# 1-year survival calibration
cal <- calibrate(cox1, cmethod = "KM", method = "boot", u = 1 * 12, m = 25, B = 500)

# 2-year survival Cox regression model
cox2 <- cph(Surv(Follow_up_time, AE) ~ Group + FEV1, 
            surv = TRUE, x = TRUE, y = TRUE, time.inc = 1 * 12 * 2, data = data)

# 2-year survival calibration
ca2 <- calibrate(cox2, cmethod = "KM", method = "boot", u = 1 * 12 * 2, m = 25, B = 500)

# 3-year survival Cox regression model
cox3 <- cph(Surv(Follow_up_time, AE) ~ Group + FEV1, 
            surv = TRUE, x = TRUE, y = TRUE, time.inc = 1 * 12 * 3, data = data)

# 3-year survival calibration
ca3 <- calibrate(cox3, cmethod = "KM", method = "boot", u = 1 * 12 * 3, m = 25, B = 500)

# Plot the 1-year survival calibration curve
plot(cal, 
     lwd = 2, 
     lty = 1, 
     errbar.col = "black", 
     xlab = "Nomogram-Predicted Probability of 1-Year Survival", 
     ylab = "Actual 1-Year Survival", 
     col = "blue", 
     sub = FALSE)

# Plot the 2-year survival calibration curve
plot(ca2, 
     lwd = 2, 
     lty = 1, 
     errbar.col = "black", 
     xlab = "Nomogram-Predicted Probability of 2-Year Survival", 
     ylab = "Actual 2-Year Survival", 
     col = "red", 
     sub = FALSE)

# Plot the 3-year survival calibration curve
plot(ca3, 
     lwd = 2, 
     lty = 1, 
     errbar.col = "black", 
     xlab = "Nomogram-Predicted Probability of 3-Year Survival", 
     ylab = "Actual 3-Year Survival", 
     col = "green", 
     sub = FALSE)

# Combine 1-year, 2-year, and 3-year survival curves on the same plot
plot(cal, 
     lwd = 2, 
     lty = 1, 
     errbar.col = "black", 
     xlim = c(0.5, 1), 
     ylim = c(0.4, 1), 
     xlab = "Nomogram-Predicted Probability of 1-, 2-, and 3-Year Survival", 
     ylab = "Actual 1-, 2-, and 3-Year Survival", 
     col = "blue", 
     sub = FALSE)

# Add 2-year survival calibration curve to the same plot
plot(ca2, 
     add = TRUE, 
     lwd = 2, 
     lty = 1, 
     errbar.col = "black", 
     col = "red", 
     sub = FALSE)

# Add 3-year survival calibration curve to the same plot
plot(ca3, 
     add = TRUE, 
     lwd = 2, 
     lty = 1, 
     errbar.col = "black", 
     col = "green", 
     sub = FALSE)

# Add legend to the plot
legend("bottomright", 
       legend = c("1-Year Survival", "2-Year Survival", "3-Year Survival"),  # Legend labels
       col = c("blue", "red", "green"),  # Legend colors
       lty = 1,                        # Legend line types
       lwd = 2,                        # Legend line width
       cex = 0.8)                      # Legend font size
